# -*- coding: latin-1 -*-

# Dies ist eine Python-Datei. Lauffhig mit Python 2.4 (oder ggf. hher).

import sys

#vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
#vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
#######################################################################
notizen = """
               Opcode     Screen                 $D800

 Rockfort:        1        88                    15

 Diamond:         2        90                     1
 Diamond_falling: 3

 Boulder:         4        81                     8
 Boulder_falling: 5

 Open Inbox:      6    (blinking between space and Titan)
 Open Outbox:     7    (blinking between space and Titan)

 Titan wall:     25      128+58 = 186            8

 Brick wall:     26      128+61 = 189           15

 Dirt:           27       102                    9

Butterfly:   8          86                      10
             9          86
            10          86
            11          66                      10

Firefly:    12         80                     1
            13        123+128                 1
            14        160                     1
            15        124+128                 1
                       76                     1

 Explode to space: 16    86                    10 
                   17   102                     1
                   18   102+128                10
                   19   102                     2
                       (space)
                      
 Explode to diamond: 20    86                    10
                     21   102                     1
                     22   102                     7
                     23    83                    15
                     24  (diamond)

 Space:              28    32                    any

Opcodes mit "scanned this frame" werden als normaler Opcode + 64 realisiert!
"""

#######################################################################
#^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#
#vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
#vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
#######################################################################
zeilen = """

 dim var_cave(1040), var_list_next(99), var_list_prev(99), var_list_val(99) , /
   element_to_farbram(40), element_to_screen(40) : /
 /
 var_farbram = 55296    : /
 var_bildschirm = 1024  : /
 var_port2 = 56320 : /
 /
   var_list_next(index_first_active) = index_last_active : /
   var_list_val (index_last_active) = var_port2 : /
   var_list_prev(index_last_active) = index_first_active : /
## var_list_next(index_last_active) = 0 : /
   var_list_next(index_first_unused) = 4 : /
 /
 poke var_port2, 255 : /
 poke var_port2 + 1 , 127 : /
 poke var_port2 + 2 , 0 : /
 poke var_port2 + 3 , 255 : /
# poke 56322,224 : /
 poke 56334,0 : / 
 /
 poke 53280,0 : poke 53281,0


 element_to_farbram(opcode_wall) = col_wall : /
 element_to_screen (opcode_wall) = scr_wall : /
 /
# element_to_farbram(opcode_dirt) = col_dirt : /
 element_to_screen (opcode_dirt) = scr_dirt : /
 /
 element_to_farbram(opcode_diamond) = col_diamond : /
 element_to_screen (opcode_diamond) = scr_diamond : /
 element_to_farbram(opcode_diamond_falling) = col_diamond : /
 element_to_screen (opcode_diamond_falling) = scr_diamond : /
 /
 element_to_farbram(opcode_explode_to_diamond_0) = col_explode_to_diamond_0 : /
 element_to_screen (opcode_explode_to_diamond_0) = scr_explode_to_diamond_0 : /
 element_to_farbram(opcode_explode_to_diamond_1) = col_explode_to_diamond_1 : /
 element_to_screen (opcode_explode_to_diamond_1) = scr_explode_to_diamond_1 : /
 element_to_farbram(opcode_explode_to_diamond_2) = col_explode_to_diamond_2 : /
 element_to_screen (opcode_explode_to_diamond_2) = scr_explode_to_diamond_2 : /
 element_to_farbram(opcode_explode_to_diamond_3) = col_explode_to_diamond_3 : /
 element_to_screen (opcode_explode_to_diamond_3) = scr_explode_to_diamond_3 : /
 /
# element_to_farbram(opcode_boulder) = col_boulder : /
 element_to_screen (opcode_boulder) = scr_boulder : /
# element_to_farbram(opcode_boulder_falling) = col_boulder : /
 element_to_screen (opcode_boulder_falling) = scr_boulder : /
 /
# element_to_farbram(opcode_titan) = col_titan : /
 element_to_screen (opcode_titan) = scr_titan : /
 /
# element_to_farbram(opcode_inbox) = col_inbox : /
 element_to_screen (opcode_inbox) = scr_inbox : /
 /
# element_to_farbram(opcode_outbox) = col_outbox : /
 element_to_screen (opcode_outbox) = scr_outbox

 element_to_farbram(opcode_rockford) = col_rockford : /
 element_to_screen (opcode_rockford) = scr_rockford : /
 /
 element_to_farbram(opcode_butterfly_0) = col_butterfly : /
 element_to_screen (opcode_butterfly_0) = scr_butterfly : /
 /
 element_to_farbram(opcode_butterfly_1) = col_butterfly : /
 element_to_screen (opcode_butterfly_1) = scr_butterfly : /
 /
 element_to_farbram(opcode_butterfly_2) = col_butterfly : /
 element_to_screen (opcode_butterfly_2) = scr_butterfly : /
 /
 element_to_farbram(opcode_butterfly_3) = col_butterfly : /
 element_to_screen (opcode_butterfly_3) = scr_butterfly : /
 /
 var_butterfly_dir_tab(0) = 1 : /
 var_butterfly_dir_tab(1) = 40 : /
 var_butterfly_dir_tab(2) = -1 : /
 var_butterfly_dir_tab(3) = -40 : /
 print "{clr}{swuc}"
 
# print chr$(147) : print : print : print : print : print : print : print : print : print
# for i = 0 to 255 : poke var_bildschirm + i , i : poke var_farbram + i , 1 : next
# end

# Init new cave:
next_cave: /
 var_inbox_counter = 35 : /
 /
 var_diamonds_collected = 0 : /
 /
 read var_diamonds_needed : /
 if var_diamonds_needed = 0 then restore : read var_diamonds_needed : var_curr_level = var_curr_level + 1

 read var_curr_cave_name, var_col_of_dirt, var_col_of_titan, var_col_of_boulder : /
 gosub update_score : /
 element_to_farbram(opcode_dirt) = var_col_of_dirt : /
 element_to_farbram(opcode_boulder) = var_col_of_boulder : /
 element_to_farbram(opcode_boulder_falling) = var_col_of_boulder : /
 element_to_farbram(opcode_titan)   = var_col_of_titan : /
 element_to_farbram(opcode_inbox)   = var_col_of_titan : /
 element_to_farbram(opcode_outbox)  = var_col_of_titan : /
 var_is_cave_won = 0 * rnd(-var_curr_level-var_diamonds_needed)

draw_init_cave_loop: /
 read var_index : on var_index goto /
# fill_dirt ,
  draw_titan_border , draw_line , draw_space_line , plot_element, plot_random, end_of_cave_data : /
 /
#fill_dirt: /
 for var_index = 120 to 959 : var_cave(var_index) = opcode_dirt : /
 poke var_farbram + var_index , var_col_of_dirt : /
 poke var_bildschirm+var_index, scr_dirt : /
 next : /
 goto draw_init_cave_loop

# TODO(SPEED): Move these lines to the top of the program!
# IN: var_element, var_pos_current_active
put_new_element_at_current: /
 param_pos = var_pos_current_active

# IN: var_element, param_pos
put_new_element_at_param_pos: /
 var_cave(param_pos) = var_element : /
 poke var_farbram   + param_pos , element_to_farbram(var_element and 63) : /
 poke var_bildschirm+ param_pos , element_to_screen (var_element and 63) : /
 if var_element <> opcode_space then return
# It's a SPACE! Add five positions to active list!!
# - MAYBE: Do this separately, for speed between erasing old char and drawing new char?!?!?
 param_pos = param_pos - 41 : on -(var_cave(param_pos) < opcode_inbox) gosub add_active : /
 param_pos = param_pos +  1 : on -(var_cave(param_pos) < opcode_inbox) gosub add_active : /
 param_pos = param_pos +  1 : on -(var_cave(param_pos) < opcode_inbox) gosub add_active : /
 param_pos = param_pos + 38 : on -(var_cave(param_pos) < opcode_inbox) gosub add_active : /
 param_pos = param_pos +  2 : on -(var_cave(param_pos) < opcode_inbox) goto  add_active : /
 return


# TODO(SPEED): Move these lines to the top of the program!
# IN: var_index_current_active, param_pos
remove_active: /
# print "remove-pos:";param_pos;"...index:";var_index_current_active : / 
 param_index = var_index_current_active : /
# print "so-param-index-is:";param_index
 if param_pos < var_list_val(param_index) goto remove__active_backw

remove__active_forw:  search_pos = var_list_val(param_index) : /
 on -(search_pos = param_pos)  goto  remove__active_here : /
 if search_pos > param_pos then return
 param_index = var_list_next(param_index) : /
 goto remove__active_forw

remove__active_here: /
  if var_index_current_active = param_index then /
#   print "hello:";var_index_current_active;"=";var_list_prev(var_index_current_active) : /
    var_index_current_active = var_list_prev(var_index_current_active)
  var_list_next(var_list_prev(param_index)) = var_list_next(param_index) : /
  var_list_prev(var_list_next(param_index)) = var_list_prev(param_index) : /
 /
#  print "param index to remove: ";param_index : /
  var_list_next(param_index) = var_list_next(index_first_unused) : /
  var_list_next(index_first_unused) = param_index : /
# goto debug_print_linked_list
  return

remove__active_backw:   search_pos = var_list_val(param_index) : /
 on -(search_pos = param_pos)  goto  remove__active_here : /
 if search_pos < param_pos then return
 param_index = var_list_prev(param_index) : /
 goto remove__active_backw



# TODO(SPEED): Move these lines to the top of the program!
# IN: var_index_current_active, param_pos
add_active: param_index = var_index_current_active : /
# var_debug_count = var_debug_count + 1 : /
# if var_debug_count > 3 then goto debug_print_linked_list
 if param_pos < var_list_val(param_index) goto add__active_backw

add__active_forw:  search_pos = var_list_val(param_index) : /
 on -(search_pos = param_pos)  goto  add__active_set : /
 on -(search_pos > param_pos)  goto  add__active_insert_forw : /
 param_index = var_list_next(param_index) : /
 goto add__active_forw

add__active_insert_forw:    index_new = var_list_next(index_first_unused) : /
   index_next_new = var_list_next(index_new) : /
   if index_next_new = 0 then index_next_new = index_new + 1

   var_list_next(index_first_unused) = index_next_new : /
 /
### var_list_prev(param_index)  index_new   param_index  var_list_next(param_index)
###                             param_pos < search_pos
 /
   var_list_next(index_new) = param_index : /
   var_list_prev(index_new) = var_list_prev(param_index) : /
   var_list_val(index_new) = param_pos : /
   var_list_next(var_list_prev(param_index)) = index_new : /
   var_list_prev(              param_index ) = index_new : /
   return

# var_list_next

add__active_set: return


add__active_backw:   search_pos = var_list_val(param_index) : /
 on -(search_pos = param_pos)  goto  add__active_set : /
 on -(search_pos < param_pos)  goto  add__active_insert_backw : /
 param_index = var_list_prev(param_index) : /
 goto add__active_backw


add__active_insert_backw:    index_new = var_list_next(index_first_unused) : /
   index_next_new = var_list_next(index_new) : /
   if index_next_new = 0 then index_next_new = index_new + 1

   var_list_next(index_first_unused) = index_next_new : /
 /
### var_list_prev(param_index)  param_index    index_new  var_list_next(param_index)
###                             search_pos  <  param_pos
 /
   var_list_next(index_new) = var_list_next(param_index) : /
   var_list_prev(index_new) = param_index : /
   var_list_val(index_new) = param_pos : /
   var_list_prev(var_list_next(param_index)) = index_new : /
   var_list_next(              param_index ) = index_new : /
   return

#end_of_cave_data: rem

# goto debug_print_linked_list

## Cave scan loop:

start_cave_scan: /
 var_index_current_active = index_first_active : /
 var_pos_current_active = 0

cave_scan_loop: /
 var_index_current_active = var_list_next(var_index_current_active) : /
 if var_index_current_active = index_last_active goto end_of_cave_scan
 var_pos_current_active = var_list_val(var_index_current_active) : /
#### poke var_farbram + var_pos_current_active , peek(53266) : /
# print var_index_current_active; var_pos_current_active
 var_element = var_cave(var_pos_current_active) : /
 on var_element goto handle_rockfort, /
#   handle_diamond_static, handle_diamond_falling, / 
    handle_boulder_static, handle_boulder_falling, /
    handle_boulder_static, handle_boulder_falling, /
    handle_inbox, handle_outbox, /
    handle_butterfly_any, handle_butterfly_any, handle_butterfly_any, handle_butterfly_any, /
    handle_explosion_any, handle_explosion_any, handle_explosion_any, handle_explosion_to_diamond : /
# Handle "scanned this frame" by "-64", but keep position active:
 if var_element > 63 then var_cave(var_pos_current_active) = var_element - 64 : goto cave_scan_loop
# Remove this element from the list since it hasn't any handler!
 param_pos = var_pos_current_active : gosub remove_active : /
 goto cave_scan_loop

# TODO(SPEED): Move these lines to the top of the program!
handle_rockfort: /
 var_joystick = peek(var_port2) : /
 /
 /
# var_rockford_dir = 0 : /
# if (var_joystick and 1) = 0 then var_rockford_dir = -40
# if (var_joystick and 2) = 0 then var_rockford_dir = 40
# if (var_joystick and 4) = 0 then var_rockford_dir = -1
# if (var_joystick and 8) = 0 then var_rockford_dir = 1
 var_rockford_dir = ((var_joystick and 4) = 0)      /
                  - ((var_joystick and 8) = 0)      : /
 /
 if var_rockford_dir = 0 then /
 var_rockford_dir = 40 * ((var_joystick and 1) = 0) /
                  - 40 * ((var_joystick and 2) = 0) : /
 /
 if var_rockford_dir = 0 goto cave_scan_loop
 /
 var_rockford_dest_pos = var_pos_current_active + var_rockford_dir : /
 /
 var_dest_element = var_cave(var_rockford_dest_pos) : /
 if var_dest_element = opcode_dirt or var_dest_element = opcode_space goto handle_rockford_just_move

 if var_dest_element = opcode_diamond then /
# MAYBE: Score per diamond different in each cave?!
   var_diamonds_collected = var_diamonds_collected + 1 : /
   poke 53280, -(var_diamonds_needed = var_diamonds_collected) : /
   var_score = var_score + 25 - (var_diamonds_needed < var_diamonds_collected) * 15 : /
   gosub update_score : /
   poke 53280,0 : /
   goto handle_rockford_just_move

 if var_dest_element = opcode_outbox and var_diamonds_needed <= var_diamonds_collected then var_is_cave_won = 1 : goto handle_rockford_just_move

 if not ( var_dest_element = opcode_boulder /
 and abs(var_rockford_dir) = 1 /
 and var_cave(var_rockford_dest_pos+var_rockford_dir) = opcode_space /
 and rnd(1) < .3 ) /
# goto handle_rockford_just_push 
 goto cave_scan_loop


handle_rockford_just_push: /
 var_element = opcode_boulder - 64 * (var_rockford_dir > 0) : /
 param_pos = var_rockford_dest_pos+var_rockford_dir : /
 gosub put_new_element_at_param_pos : /
 param_pos = var_rockford_dest_pos+var_rockford_dir : /
 gosub add_active
# Fall through!


handle_rockford_just_move: /
#   (var_joystick and 16) = 0 --> Feuerknopf
 if (var_joystick and 16) = 0 then /
 var_element = opcode_space : /
 param_pos = var_rockford_dest_pos : /
 gosub put_new_element_at_param_pos : /
 goto cave_scan_loop

# Erst neue Pos hinzufgen, dann alte Pos entfernen, damit "scanned this frame"
# nur bei +1 und +40 ntig ist!
 param_pos = var_rockford_dest_pos : /
 gosub add_active : /
 /
 param_pos = var_pos_current_active : /
 gosub remove_active : /
 /
 var_element = opcode_space : /
 param_pos = var_pos_current_active : /
 gosub put_new_element_at_param_pos : /
 /
# use "scanned_this_frame" to avoid having Rockford moved twice:
 var_element = opcode_rockford - 64 * (var_rockford_dir > 0) : /
 param_pos = var_rockford_dest_pos : /
 gosub put_new_element_at_param_pos : /
 /
# rem goto debug_print_linked_list
 goto cave_scan_loop


#handle_diamond_static: goto cave_scan_loop

#handle_diamond_falling: goto cave_scan_loop

handle_boulder_static: /
 var_dest_pos = var_pos_current_active + 40 : /
 var_dest_element = var_cave(var_dest_pos) : /
 if var_dest_element = opcode_space goto handle_boulder_start_falling
 if var_dest_element <> opcode_boulder /
 and var_dest_element <> opcode_diamond / 
 and var_dest_element <> opcode_wall goto handle_boulder_not_on_top_of_round 

# Rolling? Handling is the same as falling
 var_dest_pos = var_pos_current_active - 1 : /
 if var_cave(var_dest_pos) = opcode_space and /
    var_cave(var_dest_pos + 40) = opcode_space goto handle_boulder_start_falling
 var_dest_pos = var_pos_current_active + 1 : /
 if var_cave(var_dest_pos) = opcode_space and /
    var_cave(var_dest_pos + 40) = opcode_space goto handle_boulder_start_falling

handle_boulder_not_on_top_of_round: /
# Remove Boulder from list since it remains static.
 param_pos = var_pos_current_active : /
 gosub remove_active : /
 goto cave_scan_loop

handle_boulder_start_falling: /
 param_pos = var_dest_pos : /
 gosub add_active : /
 /
 param_pos = var_pos_current_active : /
 gosub remove_active : /
 /
 var_dest_element = var_cave(var_pos_current_active) and opcode_maske_boulder_or_diamond : /
 /
 var_element = opcode_space : /
 param_pos = var_pos_current_active : /
 gosub put_new_element_at_param_pos : /
 /
 var_element = var_dest_element + opcode_maske_boulder_falling - 64 * (var_dest_pos > var_pos_current_active) : /
 param_pos = var_dest_pos : /
 gosub put_new_element_at_param_pos : /
 /
 goto cave_scan_loop


handle_boulder_falling:  /
 var_dest_pos = var_pos_current_active + 40 : /
 if var_cave(var_dest_pos) = opcode_space goto handle_boulder_start_falling
 if var_cave(var_dest_pos) > opcode_butterfly_min /
 and var_cave(var_dest_pos) < opcode_butterfly_max goto handle_explode_now
# Boulder stopped falling:
 var_cave(var_pos_current_active) = var_cave(var_pos_current_active) and opcode_maske_boulder_or_diamond : /
 goto cave_scan_loop



# IN: var_dest_pos
handle_explode_now: /
 for var_explode_index = -40 to 40 step 40 : /
 for var_index = -1 to 1 : /
 param_pos = var_dest_pos + var_explode_index + var_index : /
 if var_cave(param_pos) <> opcode_titan then /
   gosub add_active : /
   var_element = opcode_explode_to_diamond_0 - 64 * (param_pos > var_pos_current_active) : /
   gosub put_new_element_at_param_pos
 next : next : /
 goto cave_scan_loop



handle_butterfly_any: /
 if var_cave(var_pos_current_active-40) = opcode_rockford /
 or var_cave(var_pos_current_active-1) = opcode_rockford /
 or var_cave(var_pos_current_active+1) = opcode_rockford /
 or var_cave(var_pos_current_active+40) = opcode_rockford /
 then var_dest_pos = var_pos_current_active : goto handle_explode_now
 /
 var_butterfly_step = (var_cave(var_pos_current_active) - 1) and 3 : /
 var_dest_pos = var_pos_current_active + var_butterfly_dir_tab(var_butterfly_step) : /
 if var_cave(var_dest_pos) = opcode_space goto handle_butterfly_moving

 var_butterfly_step = (var_butterfly_step + 1) and 3 : /
 var_dest_pos = var_pos_current_active + var_butterfly_dir_tab(var_butterfly_step) : /
 if var_cave(var_dest_pos) = opcode_space goto handle_butterfly_moving

 var_cave(var_pos_current_active) = opcode_butterfly_0 + ((var_butterfly_step + 1) and 3) : /
 /
 if var_anim4_counter = 3 then poke var_bildschirm+var_pos_current_active, 66
 if var_anim4_counter = 0 then poke var_bildschirm+var_pos_current_active, 86
 goto cave_scan_loop

handle_butterfly_moving: /
 param_pos = var_dest_pos : /
 gosub add_active : /
 /
 param_pos = var_pos_current_active : /
 gosub remove_active : /
 /
 var_element = opcode_space : /
 param_pos = var_pos_current_active : /
 gosub put_new_element_at_param_pos : /
 /
 var_element = opcode_butterfly_0 + var_butterfly_step - 64 * (var_dest_pos > var_pos_current_active) : /
 param_pos = var_dest_pos : /
 gosub put_new_element_at_param_pos : /
 /
 goto cave_scan_loop


handle_explosion_any: /
 var_element = var_cave(var_pos_current_active) + 1 : /
 gosub put_new_element_at_current : /
 /
 goto cave_scan_loop


handle_explosion_to_diamond: /
 var_element = opcode_diamond : /
 gosub put_new_element_at_current : /
 /
 goto cave_scan_loop


handle_inbox: /
 var_inbox_counter = var_inbox_counter - 1 : /
 poke var_bildschirm+var_pos_current_active, 32 + (var_inbox_counter and 1) * 154 : /
 if var_inbox_counter > 0 goto cave_scan_loop
# Replace inbox by Rockford:
  var_element = opcode_rockford : gosub put_new_element_at_current : /
 goto cave_scan_loop

handle_outbox: if var_diamonds_needed > var_diamonds_collected goto cave_scan_loop
 poke var_bildschirm+var_pos_current_active, 32 + (var_anim4_counter and 1) * 154 : /
 goto cave_scan_loop



end_of_cave_scan: /
  var_anim4_counter = var_anim4_counter + 1 and 3 : /
  if var_is_cave_won   goto  the_cave_is_won
# Key "Run/Stop" pressed?
  if peek(var_port2) > 127 goto start_cave_scan
# Fall through:
the_cave_is_lost: /
 for var_index = 0 to 99 : /
 var_score = int( abs ( (var_score - 1) * 0.998 ) ) : /
 gosub update_score : /
 next : /
 goto next_cave

the_cave_is_won: /
# TODO: Display winning animation!
 for var_index = 0 to 99 : /
 var_score = int( (var_score + 1) * 1.002 ) : /
 gosub update_score : /
 next : /
 goto next_cave


draw_titan_border:  /
 for var_index = 80 to 119 : /
 var_cave(var_index) = opcode_titan : /
 poke var_farbram + var_index , var_col_of_titan : /
 poke var_bildschirm+var_index, scr_titan : /
 var_cave(var_index+880) = opcode_titan : /
 poke var_farbram+880 + var_index , var_col_of_titan : /
 poke var_bildschirm+880+var_index, scr_titan : /
 next : /
 for var_index = 120 to 920 step 40 : /
 var_cave(var_index) = opcode_titan : /
 poke var_farbram + var_index , var_col_of_titan : /
 poke var_bildschirm+var_index, scr_titan : /
 var_cave(var_index+39) = opcode_titan : /
 poke var_farbram+39 + var_index , var_col_of_titan : /
 poke var_bildschirm+39+var_index, scr_titan : /
 next : /
 goto draw_init_cave_loop

draw_line:  read var_element, var_screenpos, var_len, var_direction : /
 for var_index = 0 to var_len : /
   var_cave(var_screenpos) = var_element : /
   poke var_farbram + var_screenpos , element_to_farbram(var_element) : /
   poke var_bildschirm+var_screenpos, element_to_screen(var_element) : /
   var_screenpos = var_screenpos + var_direction : /
 next : /
 goto draw_init_cave_loop

draw_space_line:  read  var_screenpos , var_len, var_direction : /
 var_element = opcode_space : /
 for var_index = 0 to var_len : /
   param_pos = var_screenpos : /
   gosub put_new_element_at_param_pos : /
   var_screenpos = var_screenpos + var_direction : /
 next : /
 goto draw_init_cave_loop

plot_random:  read var_element, var_len : /
 for var_index = 0 to var_len : /
   var_screenpos = rnd(1) * 840 + 120 : /
   var_cave(var_screenpos) = var_element : /
   poke var_farbram + var_screenpos , element_to_farbram(var_element) : /
   poke var_bildschirm+var_screenpos, element_to_screen(var_element) : /
   var_screenpos = var_screenpos + var_direction : /
 next : /
 goto draw_init_cave_loop

plot_element:  read var_element, var_screenpos : /
 var_cave(var_screenpos) = var_element : /
 poke var_farbram   + var_screenpos , element_to_farbram(var_element) : /
 poke var_bildschirm+ var_screenpos , element_to_screen (var_element) : /
 /
 var_index_current_active = var_list_next(index_first_active) : /
 param_pos = var_screenpos : /
 gosub add_active : /
 goto draw_init_cave_loop


update_score: /
 print "{home}{gry3}  cave {yel}";var_curr_cave_name; /
  "{gry3}/{yel}";mid$(str$(var_curr_level+1),2); /
  "{home}","{4 right}{wht}"; /
  right$("0"+mid$(str$(var_diamonds_collected),2),2); /
  "{gry3}Z{yel}"; : /
 /
 if var_diamonds_collected < var_diamonds_needed then /
 print right$("0"+mid$(str$(var_diamonds_needed),2),2);

 if var_diamonds_collected >= var_diamonds_needed then /
 print "ZZ";

 print "{home}{gry3}",,"{3 right}score{wht}";var_score;"{left} " : /
 return : /
 /
# Cave data:
 /
 data /
# Cave A:
# Diamonds needed:
 10, /
# Cave Name and Colors:
  a, 9, 8, 12, /
# Drawing commands:
 cmd_fill_dirt , /
 cmd_plot_random , opcode_boulder, 140 , /
 cmd_plot_random , opcode_diamond, 25 , /
 cmd_draw_line , opcode_wall, 361, 28, 1, /
 cmd_draw_line , opcode_wall, 690, 28, 1, /
 cmd_plot_element, opcode_outbox, 878, /
 cmd_plot_element, opcode_inbox, 205, /
 cmd_draw_titan_border ,/
 cmd_end_of_cave_data

 data /
# Cave B:
# Diamonds needed:
 12 , /
# Cave Name and Colors:
  b, 5, 13, 3, /
# Drawing commands:
 cmd_fill_dirt , /
 cmd_plot_random , opcode_boulder, 70 , /
 cmd_plot_random , opcode_diamond, 25 , /
 cmd_draw_line , opcode_wall, 361, 38, 1, /
 cmd_draw_line , opcode_wall, 681, 38, 1, /
 cmd_draw_line , opcode_wall, 130, 20, 40, /
 cmd_draw_line , opcode_wall, 150, 20, 40, /
 cmd_draw_line , opcode_space, 724, 3, 1, /
 cmd_plot_element, opcode_butterfly_0, 723, /
 cmd_plot_element, opcode_boulder, 339, /
 cmd_plot_element, opcode_boulder, 661, /
 cmd_draw_space_line , 140, 20, 40, /
 cmd_draw_space_line , 202, 35, 1, /
 cmd_draw_space_line , 522, 35, 1, /
 cmd_draw_space_line , 842, 35, 1, /
 cmd_plot_element, opcode_outbox, 939, /
 cmd_plot_element, opcode_inbox, 899, /
 cmd_draw_titan_border ,/
 cmd_end_of_cave_data

 data /
# Cave C:
# Diamonds needed:
 15 , /
# Cave Name and Colors:
  c, 6, 14, 3, /
# Drawing commands:
 cmd_fill_dirt , /
 cmd_plot_random , opcode_boulder, 99 , /
 cmd_plot_random , opcode_diamond, 25 , /
 cmd_draw_line , opcode_titan, 128, 17, 40, /
 cmd_draw_line , opcode_titan, 272, 17, 40, /
 cmd_draw_line , opcode_titan, 529, 20, 1, /
 cmd_plot_element, opcode_outbox, 140, /
 cmd_plot_element, opcode_inbox, 165, /
 cmd_plot_element, opcode_inbox, 917, /
 cmd_plot_element, opcode_inbox, 214, /
 cmd_draw_titan_border ,/
 cmd_end_of_cave_data

 data /
# Cave D:
# Diamonds needed:
 20 , /
# Cave Name and Colors:
  d, 2, 10, 12, /
# Drawing commands:
 cmd_fill_dirt , /
 cmd_plot_random , opcode_boulder, 99 , /
 cmd_plot_random , opcode_diamond, 22 , /
 cmd_draw_line , opcode_wall, 164, 13, 41, /
 cmd_draw_line , opcode_wall, 195, 13, 39, /
 cmd_draw_line , opcode_space, 404, 7, 40, /
 cmd_plot_element, opcode_butterfly_0, 364, /
 cmd_plot_element, opcode_dirt, 324, /
 cmd_plot_element, opcode_boulder, 284, /
 cmd_plot_element, opcode_outbox, 150, /
 cmd_plot_element, opcode_inbox, 214, /
 cmd_draw_titan_border ,/
 cmd_end_of_cave_data

 data /
# Cave E:
# Diamonds needed:
 36 , /
# Cave Name and Colors:
  e, 4, 12, 3, /
# Drawing commands:
 cmd_fill_dirt , /
 cmd_plot_random , opcode_boulder, 29 , /
 cmd_plot_random , opcode_diamond,  9 , /
 /
 cmd_draw_line   , opcode_space,       404, 7, 40, /
 cmd_plot_element, opcode_butterfly_0, 364, /
 cmd_plot_element, opcode_dirt,        324, /
 cmd_plot_element, opcode_diamond,     284, /
 /
 cmd_draw_line   , opcode_space,       372, 7, 40, /
 cmd_plot_element, opcode_butterfly_0, 412, /
 cmd_plot_element, opcode_dirt,        332, /
 cmd_plot_element, opcode_diamond,     292, /
 /
 cmd_draw_line   , opcode_space,       380, 7, 40, /
 cmd_plot_element, opcode_butterfly_0, 460, /
 cmd_plot_element, opcode_dirt,        340, /
 /
 cmd_draw_line   , opcode_space,       388, 7, 40, /
 cmd_plot_element, opcode_butterfly_0, 508, /
 cmd_plot_element, opcode_dirt,        348, /
 /
 cmd_plot_element, opcode_inbox, 224, /
 cmd_draw_titan_border ,/
 cmd_plot_element, opcode_outbox, 759, /
 cmd_end_of_cave_data

 data /
# Cave F:
# Diamonds needed:
 40, /
# Cave Name and Colors:
  f, 6, 7, 10, /
# Drawing commands:
 cmd_fill_dirt , /
 cmd_plot_random , opcode_boulder, 199 , /
 cmd_plot_random , opcode_titan, 30 , /
 cmd_plot_random , opcode_diamond, 60 , /
 cmd_draw_line , opcode_boulder, 164, 13, 41, /
 cmd_draw_line , opcode_boulder, 395, 10, 39, /
 cmd_plot_element, opcode_butterfly_0, 396, /
 cmd_plot_element, opcode_boulder, 436, /
 cmd_plot_element, opcode_inbox, 215, /
 cmd_draw_line , opcode_dirt, 681, 3, 40, /
 cmd_draw_titan_border ,/
 cmd_plot_element, opcode_outbox, 720, /
 cmd_end_of_cave_data

 data /
# Cave G:
# Diamonds needed:
 50, /
# Cave Name and Colors:
  g, 11, 14, 4, /
# Drawing commands:
 cmd_fill_dirt , /
 cmd_plot_random , opcode_boulder, 99 , /
 cmd_plot_random , opcode_diamond, 80 , /
 cmd_draw_line , opcode_wall, 140, 15, 39, /
 cmd_draw_line , opcode_wall, 350, 15, 39, /
 cmd_plot_element, opcode_inbox, 603, /
 cmd_draw_titan_border ,/
 cmd_plot_element, opcode_outbox, 319, /
 cmd_end_of_cave_data, 0


####debug_print_linked_list: /
#### /
###### DEBUG: PRINT LINKED LIST:
#### /
####  print "-idx: "; : /
####  for var_index = 0 to 8 : print               var_index ; : next : print : /
####  print "next: "; : /
####  for var_index = 0 to 8 : print var_list_next(var_index); : next : print : /
####  print "prev: "; : /
####  for var_index = 0 to 8 : print var_list_prev(var_index); : next : print : /
####  print "-val : "; : /
####  for var_index = 0 to 8 : print var_list_val (var_index); : next : print : /
####  print : /
####  print "chain (1-next):"; : /
####  var_index = 1
####loop_print_chain_next: /
####  print var_index; : /
####  var_index = var_list_next(var_index) : /
####  if var_index > 0 then loop_print_chain_next
####  print : /
#### /
####  print "chain (2-prev):"; : /
####  var_index = 2
####loop_print_chain_prev: /
####  print var_index; : /
####  var_index = var_list_prev(var_index) : /
####  if var_index > 0 then loop_print_chain_prev
####  print : /
####  end

"""
#######################################################################
#^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#
#vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
#vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
#######################################################################
ersetzungen = """

 index_first_active      1
 index_last_active       2
 index_first_unused      3

 cmd_fill_dirt           0
 cmd_draw_titan_border   1
 cmd_draw_line           2
 cmd_draw_space_line     3
 cmd_plot_element        4
 cmd_plot_random         5
 cmd_end_of_cave_data    6

 end_of_cave_data   start_cave_scan

 opcode_maske_boulder_or_diamond 6
 opcode_maske_boulder_falling    1

 opcode_boulder_falling_stf  133
 opcode_boulder_falling      5
 opcode_boulder  4
 scr_boulder     81
 col_boulder     8

 opcode_diamond_falling_stf  131
 opcode_diamond_falling      3
 opcode_diamond  2
 scr_diamond     90
 col_diamond     1

 opcode_wall     26
 scr_wall        189
 col_wall        15

 opcode_space    28
 scr_space       32
 col_space       0

 opcode_dirt     27
 scr_dirt        102
 col_dirt        9

 opcode_titan    25
 scr_titan       186
 col_titan       8

 opcode_inbox    6
 scr_inbox       186
 col_inbox       8

 opcode_outbox   7
 scr_outbox      186
 col_outbox      8

 opcode_rockford 1
 scr_rockford    88
 col_rockford    15

 opcode_butterfly_min  7
 opcode_butterfly_0    8
 opcode_butterfly_1    9
 opcode_butterfly_2    10
 opcode_butterfly_3    11
 opcode_butterfly_max  12
 scr_butterfly    86
 col_butterfly    10

 opcode_explode_to_diamond_0  12
 opcode_explode_to_diamond_1  13
 opcode_explode_to_diamond_2  14
 opcode_explode_to_diamond_3  15
 col_explode_to_diamond_0       10
 scr_explode_to_diamond_0       86
 col_explode_to_diamond_1       1
 scr_explode_to_diamond_1       102
 col_explode_to_diamond_2       7
 scr_explode_to_diamond_2       102
 col_explode_to_diamond_3       15
 scr_explode_to_diamond_3       83

 element_to_farbram  a
 element_to_screen   b

 var_index_current_active  c
 var_pos_current_active    d

 var_index       e
 var_element     f
 var_len         g
 var_screenpos   h
 var_direction   i

 var_list_next   j
 var_list_prev   k
 var_list_val    l

 var_cave        m
 var_farbram     n
 var_bildschirm  o

 param_index    p
 param_pos      q
 
 search_pos             r
 index_new              s
 index_next_new         t

 var_joystick           u
 var_port2              v
 var_rockford_dir       w
 var_rockford_dest_pos  x
 var_dest_element       y
 var_dest_pos           z
 var_score              aa
 var_diamonds_needed    ab
 var_diamonds_collected ac
 var_inbox_counter      ad
 var_explode_index      ae
 var_is_cave_won        af
 var_col_of_dirt        ag
 var_col_of_titan       ah
 var_col_of_boulder     ai
 var_curr_level         aj
 var_anim4_counter      ak
 var_butterfly_dir_tab  al
 var_butterfly_step     am

 var_debug_count        dc

 var_curr_cave_name     a$

"""
#######################################################################
#^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^



ersetz = []
for e in ersetzungen.splitlines():
  e = e.strip()
  if len(e) > 0:
    ersetz.append(e.split())

print `ersetz`

zeilen_neu = []
letzte = ""
for z in zeilen.splitlines():
  if len(z.strip()) > 0 and z[0] != '#':
    if z.rstrip()[-1] == "/":
      z = z.rstrip()[:-1]
      if len(letzte) > 0:
        letzte = letzte + z
      else:
        letzte = z
    else:
      if len(letzte) > 0:
        z = letzte + z
      for a,b in ersetz:
        z = z.replace(a,b)
      zeilen_neu.append(z)
      letzte = ""

zeilen = zeilen_neu
print `zeilen`

# GOTO-Label implementieren:
zeilen_neu = []
nrn = []
for nr, z in enumerate(zeilen):
  if len(z) > 0 and z[0] != ' ':
    i = z.find(':')
    la = z[0:i]
    z = z[i+1:]
    nrn.append( [la, str(nr)] )
#   print `la`
#   print `z`
  zeilen_neu.append(z)

zeilen = zeilen_neu
print `nrn`

zeilen_neu = []
for z in zeilen:
  for a,b in nrn:
    z = z.replace(a,b)
  zeilen_neu.append(z)

zeilen = zeilen_neu
print `zeilen`

# Spaces entfernen, aber nicht zwischen Anfhrungszeichen:
zeilen = ['"'.join([ [z.replace(" ", ""),z][i&1] for i,z in enumerate(zeile.split('"'))]) for zeile in zeilen]

print `zeilen`

print "Debug-Zeilennummern:"
for a,b in nrn:
  if a.lower().find("debug") >= 0:
    print "%s : %s" % (b, a)

s = ""
for nr, z in enumerate(zeilen):
  s = s + (str(nr)+z+"\n")
  if z.find("_") >= 0:
    print "WARNUNG: '_' in Zeile %d: %s" % (nr, z)

save_filename = "4k-basic-dash.bas"

f = open(save_filename, 'w')
f.write(s)
f.close()
